function DisplayCtrl($scope, $rootScope, StructureJson, $timeout){
    /**
     * Rozkładówki
     *
     * @type {*}
     */
    $scope.pages = StructureJson.getPages();


    $scope.leftPageIndex = StructureJson.getLeftPageIndex();

    $scope.isFirstPageSingle = StructureJson.isFirstPageSingle();



    $scope.$on('Page:change', function(e, changeData){
        if(changeData.singleView)
        {
            if(!changeData.isLeftPage && changeData.direction == 1)
            {
                $scope.frontLeftPage = $scope.getNextPage(changeData.currentPage);
                $scope.frontRightPage = $scope.getNextPage($scope.frontLeftPage);
            }

            if(changeData.isLeftPage && changeData.direction == -1)
            {
                $scope.frontRightPage = $scope.getPreviousPage(changeData.currentPage);
                $scope.frontLeftPage = $scope.getPreviousPage($scope.frontRightPage);
            }
        }
        else
        {
            if(changeData.direction == 1)
            {
                $scope.frontLeftPage = $scope.getNextPage($scope.getNextPage(changeData.currentPage));
                $scope.frontRightPage = $scope.getNextPage($scope.frontLeftPage);
            }
            else
            {
                $scope.frontRightPage = $scope.getPreviousPage(changeData.currentPage);
                $scope.frontLeftPage = $scope.getPreviousPage($scope.frontRightPage);
            }
        }

        $scope.$apply();
    });


    $scope.$on('Page:jump', function(e, page){
        if(StructureJson.isLeftPage(page))
        {
            $scope.frontLeftPage = page;
            $scope.frontRightPage = StructureJson.getNextPage(page);
        }
        else
        {
            $scope.frontRightPage = page;
            $scope.frontLeftPage = StructureJson.getPreviousPage(page);
        }
        $scope.$apply();
    });



    $scope.$watch('frontLeftPage', function(newValue){
        $scope.page = 0;
        if(newValue !== false)
        {
            var firstPageIndex = $scope.pages.indexOf($scope.frontLeftPage) + 1;
            $scope.page = ($scope.pages.length == firstPageIndex) ? firstPageIndex : firstPageIndex + ' - ' + (++firstPageIndex);
        }
        else
        {
            $scope.page = 1;
        }

    });


    $scope.fitPageInWindow = function(){
        var scale = getScale($rootScope.pageMaxWidth, $rootScope.pageMaxHeight, 2 * StructureJson.getPageWidth(), StructureJson.getPageHeight());
        angular.element('.pages').css('width', 2 * scale * StructureJson.getPageWidth()).css('height', scale * StructureJson.getPageHeight());
    }
    $scope.fitPageInWindow();
    $rootScope.$on('Window:resize', function(){

        $scope.fitPageInWindow();
        $scope.$apply();
    });


    /**
     * Pobiera następną stronę względem podanej
     * @param page
     * @returns {boolean}
     */
    $scope.getNextPage = function(page){
        return StructureJson.getNextPage(page);
    }

    /**
     * Pobiera poprzednią stronę względem podanej
     *
     * @param page
     * @returns {*}
     */
    $scope.getPreviousPage = function(page){
        return StructureJson.getPreviousPage(page);
    }

    /**
     * Obecnie przeglądana rozkładówka
     *
     * @type {*}
     */
    $scope.frontLeftPage = ($scope.leftPageIndex == false) ? false :$scope.pages[$scope.leftPageIndex];
    $scope.frontRightPage = $scope.getNextPage($scope.frontLeftPage);


    /**
     * Przesunięcie strony do tyłu
     */
    $scope.goToPreviousPage = function(){
        if(!$scope.isFirst())
        {
            $rootScope.$broadcast('Page:beforeChange', {
                direction: -1,
                singleView: 0,
                isLeftPage: StructureJson.isLeftPage($scope.frontLeftPage),
                currentPage: $scope.frontLeftPage
            });
        }
    }



    /**
     * Przejścei do nastepnej strony
     */
    $scope.goToNextPage = function(){
        if(!$scope.isLast())
        {
            $rootScope.$broadcast('Page:beforeChange', {
                direction: 1,
                singleView: 0,
                isLeftPage: StructureJson.isLeftPage($scope.frontLeftPage),
                currentPage: $scope.frontLeftPage
            });
        }
    }


    $scope.getBackgroundUrl = function(page){
        if(page == false || typeof page == 'undefined')
        {
            return '';
        }
        else if($scope.isFrontLeftPage(page))
        {
            return dataPath + $scope.frontLeftPage.preview;
        }
        else if($scope.isFrontRightPage(page))
        {
            return dataPath + $scope.frontRightPage.preview;
        }
        else
        {
            return '';
        }
    }


    /**
     * Czy obecna strona jest pierwszą
     * @returns {boolean}
     */
    $scope.isFirst = function(){
        return (($scope.isFirstPageSingle && $scope.pages.indexOf($scope.frontRightPage) == 0) || (!$scope.isFirstPageSingle && $scope.pages.indexOf($scope.frontLeftPage) == 0));
    }


    /**
     * Czy obecna strona jest ostatnią
     * @returns {boolean}
     */
    $scope.isLast = function(){
        return (($scope.isFirstPageSingle && $scope.pages.indexOf($scope.frontLeftPage) == $scope.pages.length - 1) || (!$scope.isFirstPageSingle && $scope.pages.indexOf($scope.frontRightPage) == $scope.pages.length - 1));
    }

    /**
     * Sprawdza czy podana strona jest jedną ze stron aktywnych, następnych lub poprzednich
     * @param page
     * @returns {*}
     */
    $scope.isActive = function(page){
        return ($scope.isFrontLeftPage(page) || $scope.isFrontRightPage(page) || $scope.isNextLeftPage(page) || $scope.isNextRightPage(page) || $scope.isPrevLeftPage(page) || $scope.isPrevRightPage(page));
    }


    $scope.isFrontLeftPage = function(page){
        return page == $scope.frontLeftPage;
    }


    $scope.isFrontRightPage = function(page){
        return page == $scope.frontRightPage;
    }
}
DisplayCtrl.$inject = ['$scope', '$rootScope', 'StructureJson', '$timeout'];